#Running the narwhal using an updated den sim function
#(allows time at den between .5 and 22.5 (per Eric Andersen's data))
#as well as an updated disturbance sim function
# (if FLIR locates a den, moves max 1/2 mile so only stops early den lethality, 
#   but leaves late den and post den effects even if FLIR--ONLY for dens within the half mile buffer.
#   (other dens from 1/2-1 mile are removed from potential disturbance))

library(sf)
library(raster)
library(maptools)
library(spatstat)
library(ald)
library(maptools)
library(foreach)
library(doParallel)
library(stringi) #used to manipulate Sys.time() for appending to output file names

setwd("XXXXXXXXXXXXXX") #set this to the directory in which you put all the analysis files

load("helper_objects_V5.2_,20240925_114930.067491.RData")
source("modified denning code/disturbance.function.V5.2NARWHAL.R", echo=TRUE) #see above description of code modification
source("~/MMM/projects/2024 AOGA remand/den disturbance files for record MAR2025update/den.func.parallel.remand.R", echo=TRUE) #see above description of code modification
#this den function has a different name to not overwrite the default (it will eventually be part of new releases)

#updating a function for inserting time into file names
insert.time2 = function(){ 
  #a little better format than previous, now YYYY_MM_DD_hhmmss
  require(stringi)
  return(stri_replace_all_fixed(format(Sys.time(), "%F %T"),pattern=c(" ","-",":"," AKDT"),replacement=c("_","_","",""),vectorize_all = F))
  
}

dev.path=""   # this is the common directory for where development objects are stored (or their sub directories) can also hard code below if needed
out.path="Narwhalout/"
if (! dir.exists(out.path) ) dir.create(out.path) #create an output folder if doesn't exist


long.years = c("2025-2026")
short.years = c("2526")


############
#simulate dens or read in existing sims
if(0){  #not always simulating new dens, using ones already created if they exist, otherwise change to if(1) to force code to execute
  #Simulate a set of simulated dens for use in disturbance function
  library(foreach)
  library(doParallel)
  
  for (e.y in 2026){  
    print(Sys.time())
    writeLines(paste("starting den sim for emergence year",e.y))
    print(Sys.time())
    
    n.sim =10000
    {
      temp.time=Sys.time()
      cl <- makePSOCKcluster(detectCores()-1)#  15)
      registerDoParallel(cl)
      sim.dens=vector()
      sim.dens=foreach(i=1:n.sim,.packages=c("raster","spatstat","ald","sf"),.errorhandling='pass',.verbose=F,.multicombine=TRUE) %dopar%
        # den.func.parallel(emerg.year=e.y)
      den.func.parallel.remand(emerg.year=e.y) #use updated den sim function
      
      stopCluster(cl)
      print(Sys.time()-temp.time)
    }
    saveRDS(sim.dens,paste0(out.path,"sim.dens",e.y-1,"-",e.y,"_", insert.time2(), ".rds"))
  }#for (e.y)  
}#end if(0) (simulate new dens)

#to use dens already simulated
sim.dens2526 = readRDS("Narwhalout/sim.dens2025-2026_2025_04_08_121025.rds")

#get development info
start.stop.names = c("Start","End")  #names of all columns needed for start/stop date info

if(0){ #dont need to rerun if already created, otherwise change to if(1) to force code to execute
fgdb="updated_denning_analysis_V2.gdb" #some features had inconsistent date formatting, made a version consistent within features
file.layers = st_layers(fgdb)
# Available layers:
#        layer_name                 geometry_type features fields            crs_name
# 1      denning_polygons                 Multi Polygon       28     10 NAD83 / UTM zone 5N
# 2 updated_denning_lines 3D Measured Multi Line String       33     13 NAD83 / UTM zone 5N
denning.polygons       <- import.shapefile(file.name = fgdb, layer.name = "denning_polygons"           , start.stop.names = start.stop.names ,date.format='%m-%d-%Y')
updated.denning.lines  <- import.shapefile(file.name = fgdb, layer.name = "updated_denning_lines"      , start.stop.names = start.stop.names ,date.format='%m-%d-%Y')
all.dev  = merge.dev.objects2(denning.polygons,updated.denning.lines)  
all.2526.dev = combine.compact.feature(all.dev,col.names = start.stop.names[1:2])
plot(all.2526.dev[[1]])

##########################
##########################
#generate FLIR data
##########################

#in ALL years                        
#2 FLIR: 12/1-12-25; 12/15-1/10

FLIR.2526 = do.call(union.owin,all.2526.dev$unique.dev.list.buff) #combine all objects  


#plot them if you like

plot(FLIR.2526, main="FLIR 2526")

FLIR.owin.list.2526 = list(FLIR.2526, FLIR.2526)


FLIR.dates.2526 = data.frame(start = c(strptime('2025-12-01','%Y-%m-%d'),strptime('2025-12-25','%Y-%m-%d')),
                             end   = c(strptime('2025-12-15','%Y-%m-%d'),strptime('2026-01-10','%Y-%m-%d')))

#add FLIR info to dev.objects
all.2526.dev = append(all.2526.dev,list(FLIR.owin.list=FLIR.owin.list.2526, FLIR.dates=FLIR.dates.2526, study.area.owin = FLIR.2526 ) )


# #save all yearly dev objects
saveRDS(all.2526.dev, paste0(out.path,"Narwhal2526.dev_", insert.time2(),  ".rds"))#out.path,   #not putting in output path for this particular analysis
}# end if 0
# 
# to use already created development data
 all.2526.dev    = readRDS("Narwhalout/Narwhal2526.dev_2025_03_20_100832.rds")


##########
#done with creating development data

#################
#################
#################
#plot all the FLIR objects with dates of flir  

#read coastline (used in plotting)
ak.coast  = st_read("C:/Users/achrist/OneDrive - DOI/Documents/MMM/projects/000 common files for den analyses/AK coast/ak_coast63k_aa154n83_Line_Ncoast.shp")
ak.coast = st_zm(ak.coast) #drop 3rd dimension as we don't need it (won't do anything if already 2d)
ak.coast = st_transform(ak.coast,akproj)

boundingbox(all.2526.dev[[1]])
# window: rectangle = [46135.09, 156649.43] x [2271446.6, 2302240.1] units



bbox.x = c(46100, 157000) #bounding box used for plotting
bbox.y = c(2270000, 2310000)

for (i in 1:length(long.years)){
  pdf(paste0(out.path,"Dev.FLIR.plots_",short.years[i],".",insert.time2(), ".pdf"),width = 10,height = 7.5)#out.path,
  tmp=get(eval(paste0("all.",short.years[i],".dev")))
  plot(tmp[[1]],xlim=bbox.x,ylim=bbox.y,col="red",
       main=paste("Narwhal",long.years[i],"development footprint (unbuffered)"))
  plot(ak.coast[,1],col="black",lwd=2,add=T)
  for(j in 1:length(tmp$FLIR.owin.list)){
    plot(tmp$FLIR.owin.list[[j]],col=j+1,xlim=bbox.x,ylim=bbox.y,
         main=paste(long.years[i],"FLIR date",tmp$FLIR.dates[j,1],"to",tmp$FLIR.dates[j,2])); plot(ak.coast[,1],col="black",lwd=2,add=T)
  }
  dev.off()
}


##########################
#we now have all the input data available
# can run disturbance sim
library(foreach)
library(doParallel)



#run den disturbance sim
dens.vals = c("sim.dens2526" )
devs.vals = c("all.2526.dev")
out.vals  = c("sim.dist2526_")
dist.vals = c("sim.dist2526" )



if(0){ #have disturbance objects we can read in, only need to rerun if want another sim 
  for(iii in 1) {  
    # assumes these objects loaded in workspace: sim.dens2526 and all.2526.dev
    
    cl <- makePSOCKcluster(15) #was throwing errors outside the loop, so put here and also cleanup at end NOTE:MAY NEED TO SET TO FEWER CLUSTERS IF HAVE FEWER PROCESSORS
    
    sim.dens = get(eval(dens.vals[iii])) #already loaded in workspace at top of this file
    list2env(get(eval(devs.vals[iii])),globalenv())  #put all elements of returned list into global environment
    names(unique.dev.dates) = c("start","end") #need to not have the years in the name
    {
      temp.time=Sys.time()
      registerDoParallel(cl)
      x=vector()
      x=foreach(i=1:length(sim.dens),.packages=c("terra","st","raster","spatstat"),.errorhandling='pass',.verbose=F,.multicombine=TRUE) %dopar%
        disturbance.func.parallel.FLIRvar.narwhal(dens=sim.dens[[i]],  ###############use special modification specific to Narwhal
                                          #probabilities were updated 4/1/25 by Ryan
                                          prob.resp.estab = c( 9/12, 3/12,     0,    0), #c(0.750, 0.250, 0.000, 0.000), None, levB, LevA, Lethal
                                          prob.resp.early = c(12/13,    0,     0, 1/13), #c(0.923, 0.000, 0.000, 0.077), None, LevB, LevA, Lethal
                                          prob.resp.late  = c(26/38,    0, 12/38,    0), #c(0.684, 0.000, 0.316, 0.000), None, LevB, LevA, Lethal
                                          prob.resp.post  = c(    0, 6/19, 13/19,    0), #c(0.000, 0.316, 0.684, 0.000), None, LevB, LevA, Lethal
                                          prob.resp.post2 = c(    0, 8/12,  4/12,    0), #c(0.000, 0.667, 0.333, 0.000), None, LevB, LevA, Lethal#If disturbed during late denning, prob of being disturbed during post emergence
                                          dev.obj          =unique.dev.owin,
                                          dev.obj.list     =unique.dev.list,
                                          dev.obj.list.buff=unique.dev.list.buff, 
                                          dev.obj.dates    =unique.dev.dates,
                                          FLIR.regions     =FLIR.owin.list,
                                          FLIR.dates       =FLIR.dates)
      stopCluster(cl)
      print(Sys.time()-temp.time)
      
      sim.dist =list(lapply(x,FUN=function(xx) xx[[1]]),
                     do.call(rbind,lapply(x,FUN = function(xx) xx[[2]])),
                     lapply(x,FUN = function(xx) xx[[3]])   )
    }
    saveRDS(sim.dist,paste0(out.path,out.vals[iii], insert.time2(),".rds"))#save disturbance output
    assign(dist.vals[iii],sim.dist) #rename a copy to have in the workspace
    env <- foreach:::.foreachGlobals; rm(list=ls(name=env), pos=env); rm(env) #do some cleanup a la https://stackoverflow.com/questions/25097729/un-register-a-doparallel-cluster
  } #end for iii
} #end if(0)  (code for running disturbance sim)

#to read in already created disturbance simulation data
sim.dist2526 = readRDS(paste0(out.path,"sim.dist2526_2025_04_08_124805.rds"))


sink(paste0(out.path,"Narwhal Summary Stat output_", insert.time2(),".txt"),split=T)#out.path,#write the output to a file split sends to new sink and current output stream
#this code presumes sim.dist2526 in workspace
for(i in 1){
  sim.dist = get(eval(dist.vals[i])) #already loaded in workspace at top of this file
  writeLines(paste("Narwhal den disturbance output for",long.years[i] ))
  tmp = summary.stats(sim.dist)
  print(tmp, row.names = FALSE)
  writeLines("\n\n\n")
}

sink()
